﻿using SIS.Entidades;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web.Script.Serialization;
using System.Windows.Forms;

namespace SIS
{
    public static class Util
    {

        public static string RemoverPontuacao(string texto)
        {
            StringBuilder sb = new StringBuilder();
            foreach (char c in texto)
            {
                if (!char.IsPunctuation(c))
                    sb.Append(c);
                else
                    sb.Append(" ");
            }
            return sb.ToString();          
        }

        public static string RemoverStopWords(string texto)
        {
            StringBuilder sb = new StringBuilder();
            var stopWords = File.ReadAllLines(Application.StartupPath + @"\AppData\StopWords.txt");
            string textoFinal = string.Empty;
            var palavras = texto.Split();
            var novasPalavras = palavras.Except(stopWords, StringComparer.InvariantCultureIgnoreCase);
            textoFinal = string.Join(" ", novasPalavras);
            return textoFinal;
        }

        public static string[] Tokenizar(string texto)
        {
            var arrayPalavras = texto.Split();
            arrayPalavras = arrayPalavras.Where(x => !string.IsNullOrEmpty(x)).ToArray();
            return arrayPalavras;
        }

        public static Sentimentos RetornarObjetoSentimento()
        {
            Sentimentos oSentimentos = new Sentimentos();

            oSentimentos.Alegria.Palavras = File.ReadAllLines(Application.StartupPath + @"\AppData\Sentimentos\Alegria.txt").ToList();
            oSentimentos.Desgosto.Palavras = File.ReadAllLines(Application.StartupPath + @"\AppData\Sentimentos\Desgosto.txt").ToList();
            oSentimentos.Medo.Palavras = File.ReadAllLines(Application.StartupPath + @"\AppData\Sentimentos\Medo.txt").ToList();
            oSentimentos.Raiva.Palavras = File.ReadAllLines(Application.StartupPath + @"\AppData\Sentimentos\Raiva.txt").ToList();
            oSentimentos.Surpresa.Palavras = File.ReadAllLines(Application.StartupPath + @"\AppData\Sentimentos\Surpresa.txt").ToList();
            oSentimentos.Tristeza.Palavras = File.ReadAllLines(Application.StartupPath + @"\AppData\Sentimentos\Tristeza.txt").ToList();


            return oSentimentos;
        }

        public static List<PercentualPorSentimento> RetornarPercentualPorSentimento(List<string> textoTokenizado, Sentimentos objSentimentos , bool usarStemmer)
        {
            ContadorSentimento oContadorSentimento = new ContadorSentimento();

            List<string> listaSentimentoAlegria = new List<string>();
            List<string> listaSentimentoDesgosto = new List<string>();
            List<string> listaSentimentoMedo = new List<string>();
            List<string> listaSentimentoRaiva = new List<string>();
            List<string> listaSentimentoSurpresa = new List<string>();
            List<string> listaSentimentoTristeza = new List<string>();
            List<string> listaNovoTexto = new List<string>();

            IStemmer stemmer = new PortugueseStemmer();

            if(usarStemmer==false)
            {
                listaSentimentoAlegria = objSentimentos.Alegria.Palavras;
                listaSentimentoDesgosto = objSentimentos.Desgosto.Palavras;
                listaSentimentoMedo = objSentimentos.Medo.Palavras;
                listaSentimentoRaiva = objSentimentos.Raiva.Palavras;
                listaSentimentoSurpresa = objSentimentos.Surpresa.Palavras;
                listaSentimentoTristeza = objSentimentos.Tristeza.Palavras;
                listaNovoTexto = textoTokenizado;
            }
            else
            {
                foreach(string p in objSentimentos.Alegria.Palavras)
                    listaSentimentoAlegria.Add(stemmer.GetSteamWord(p));

                foreach (string p in objSentimentos.Desgosto.Palavras)
                    listaSentimentoDesgosto.Add(stemmer.GetSteamWord(p));

                foreach (string p in objSentimentos.Medo.Palavras)
                    listaSentimentoMedo.Add(stemmer.GetSteamWord(p));

                foreach (string p in objSentimentos.Raiva.Palavras)
                    listaSentimentoRaiva.Add(stemmer.GetSteamWord(p));

                foreach (string p in objSentimentos.Surpresa.Palavras)
                    listaSentimentoSurpresa.Add(stemmer.GetSteamWord(p));

                foreach (string p in objSentimentos.Tristeza.Palavras)
                    listaSentimentoTristeza.Add(stemmer.GetSteamWord(p));

                foreach (string p in textoTokenizado)
                    listaNovoTexto.Add(stemmer.GetSteamWord(p));
            }

            foreach (string word in listaSentimentoAlegria.Distinct())
            {
                if (listaNovoTexto.Contains(word))
                    oContadorSentimento.Alegria++;
            }
            foreach (string word in listaSentimentoDesgosto.Distinct())
            {
                if (listaNovoTexto.Contains(word))
                    oContadorSentimento.Desgosto++;
            }
            foreach (string word in listaSentimentoMedo.Distinct())
            {
                if (listaNovoTexto.Contains(word))
                    oContadorSentimento.Medo++;
            }
            foreach (string word in listaSentimentoRaiva.Distinct())
            {
                if (listaNovoTexto.Contains(word))
                    oContadorSentimento.Raiva++;
            }
            foreach (string word in listaSentimentoSurpresa.Distinct())
            {
                if (listaNovoTexto.Contains(word))
                    oContadorSentimento.Surpresa++;
            }
            foreach (string word in listaSentimentoTristeza.Distinct())
            {
                if (listaNovoTexto.Contains(word))
                    oContadorSentimento.Tristeza++;
            }
            
            double totalEmotion = oContadorSentimento.Alegria +
                                  oContadorSentimento.Desgosto +
                                  oContadorSentimento.Medo +
                                  oContadorSentimento.Raiva +
                                  oContadorSentimento.Surpresa +
                                  oContadorSentimento.Tristeza;

            oContadorSentimento.PercentualAlegria = (oContadorSentimento.Alegria / totalEmotion) * 100;
            oContadorSentimento.PercentualDesgosto = (oContadorSentimento.Desgosto / totalEmotion) * 100;
            oContadorSentimento.PercentualMedo = (oContadorSentimento.Medo / totalEmotion) * 100;
            oContadorSentimento.PercentualRaiva = (oContadorSentimento.Raiva / totalEmotion) * 100;
            oContadorSentimento.PercentualSurpresa = (oContadorSentimento.Surpresa / totalEmotion) * 100;
            oContadorSentimento.PercentualTristeza = (oContadorSentimento.Tristeza / totalEmotion) * 100;

            List<PercentualPorSentimento> listaPercentualPorSentimento = new List<PercentualPorSentimento>();
            listaPercentualPorSentimento.Add(new PercentualPorSentimento { Sentimento = "Alegria", Percentual = Math.Round(oContadorSentimento.PercentualAlegria) });
            listaPercentualPorSentimento.Add(new PercentualPorSentimento { Sentimento = "Desgosto", Percentual = Math.Round(oContadorSentimento.PercentualDesgosto) });
            listaPercentualPorSentimento.Add(new PercentualPorSentimento { Sentimento = "Medo", Percentual = Math.Round(oContadorSentimento.PercentualMedo) });
            listaPercentualPorSentimento.Add(new PercentualPorSentimento { Sentimento = "Raiva", Percentual = Math.Round(oContadorSentimento.PercentualRaiva) });
            listaPercentualPorSentimento.Add(new PercentualPorSentimento { Sentimento = "Surpresa", Percentual = Math.Round(oContadorSentimento.PercentualSurpresa) });
            listaPercentualPorSentimento.Add(new PercentualPorSentimento { Sentimento = "Tristeza", Percentual = Math.Round(oContadorSentimento.PercentualTristeza) });

            return listaPercentualPorSentimento;
        }
    }
}
