﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Web.Script.Serialization;
using SIS.Entidades;
using System.IO;

namespace SIS
{
    public partial class FrmPrincipal : Form
    {
        public FrmPrincipal()
        {
            InitializeComponent();
        }

        private void FrmPrincipal_Load(object sender, EventArgs e)
        {
            txtTextoOrigem.Focus();
        }

        private void btnIdentificarSentimento_Click(object sender, EventArgs e)
        {
            string textoOrigem = txtTextoOrigem.Text;
            string textoSemPontuacao = Util.RemoverPontuacao(textoOrigem);
            string textoSemStopWord = Util.RemoverStopWords(textoSemPontuacao);

            var arrayPalavras = Util.Tokenizar(textoSemStopWord);
            var oSentimentos = Util.RetornarObjetoSentimento();

            var retornoPercentualPorSentimento = Util.RetornarPercentualPorSentimento(arrayPalavras.ToList(), oSentimentos, true);

            JavaScriptSerializer oJS = new JavaScriptSerializer();
            var json = oJS.Serialize(retornoPercentualPorSentimento);
            txtResultadoJson.Text = json;

            foreach(var s in retornoPercentualPorSentimento)
            {
                if (s.Sentimento == "Alegria")
                    lblAlegria.Text = s.Percentual.ToString();
                if (s.Sentimento == "Desgosto")
                    lblDesgosto.Text = s.Percentual.ToString();
                if (s.Sentimento == "Medo")
                    lblMedo.Text = s.Percentual.ToString();
                if (s.Sentimento == "Raiva")
                    lblRaiva.Text = s.Percentual.ToString();
                if (s.Sentimento == "Surpresa")
                    lblSurpreza.Text = s.Percentual.ToString();
                if (s.Sentimento == "Tristeza")
                    lblTristeza.Text = s.Percentual.ToString();
            }
        }

        private void btnLimpar_Click(object sender, EventArgs e)
        {
            txtTextoOrigem.Text = String.Empty;
            txtResultadoJson.Text = String.Empty;

            lblAlegria.Text = String.Empty;
            lblDesgosto.Text = String.Empty;
            lblMedo.Text = String.Empty;
            lblRaiva.Text = String.Empty;
            lblSurpreza.Text = String.Empty;
            lblTristeza.Text = String.Empty;

            txtTextoOrigem.Focus();
        }


    }
}
